#include <Pilot.h>
#include "stationary2_res.h"

extern void __Startup__();
extern Boolean EventLoop();
extern void AppHandleEvent(EventPtr, int*,int*);
extern VoidPtr GetObjectPtr( int );
extern void SetResultValue(Word fieldID, CharPtr str);
extern void DATRAINFormInit(FormPtr form);
extern void DATRAINFormTerm();

void
__Startup__()
{
	FormPtr form;
	Boolean result;	
	//Boolean InsertionPt;
	
	//InsertionPt = InsPtEnabled();
	//InsPtEnable(false);
		
	form = FrmInitForm(DATRAINForm);
	FrmDrawForm(form);
	FrmSetActiveForm(form);

	DATRAINFormInit(form);
	result = EventLoop();
	DATRAINFormTerm();
		
	FrmEraseForm(form);
	FrmDeleteForm(form);

	//InsPtEnable( InsertionPt);
	
	return;
}

Boolean
EventLoop()
{
	EventType ev;
	int done =0;
	int result;
	
	do {
		EvtGetEvent( &ev,0);
		if (!SysHandleEvent( &ev))
			if (!FrmHandleEvent(FrmGetActiveForm(), &ev))
			AppHandleEvent(&ev,&done,&result);
	} while (!done);
	
	return result;
}

VoidPtr GetObjectPtr( int id )
{
	FormPtr form;
	form = FrmGetActiveForm();
	return( FrmGetObjectPtr( form, FrmGetObjectIndex(form,id)));
}

void
SetResultValue(Word fieldID, CharPtr str)
{
	Handle h1,h2;
	CharPtr p;
	FieldPtr field;
	Boolean fieldEditable;
	
	h1 = MemHandleNew( StrLen( str)+1);
	p = MemHandleLock( h1);
	StrCopy( p,str);
	MemHandleUnlock(h1);
	
	field = (FieldPtr)GetObjectPtr(fieldID);
	h2 = FldGetTextHandle( field);

	fieldEditable		= field->attr.editable;
	field->attr.editable	= true;
	
	FldSetTextHandle( field,h1);
	FldDrawField( field);

	field->attr.editable	= fieldEditable;
	
	if ( h2 != 0)
		MemHandleFree( h2);	
}

void
AppHandleEvent(EventPtr ev, int *done,int *result)
{
	FieldPtr	rstP;

	if (ev->eType == appStopEvent){
		*done = true;
		*result = 0;
		EvtAddEventToQueue (ev);
		return;
	} else 	if (ev->eType == ctlSelectEvent){
		switch (ev->data.ctlSelect.controlID ){
			case DATRAINCancelButton:
				*done = true;
				*result = 0;
				break;		
		}
	} else if (ev->eType == keyDownEvent){
		rstP = GetObjectPtr(DATRAINResultField);
		switch (ev->data.keyDown.chr){
			case pageUpChr:
				FldScrollField (rstP, 1, up);
				break;
			case pageDownChr:
				FldScrollField (rstP, 1, down);
				break;
		}
	} 

}

void DATRAINFormInit(FormPtr form)
{
	LocalID		l;
	DmOpenRef	d;
	CharPtr		recP;
	VoidHand	recH;

	SystemPreferencesType sysPrefs;
	DateTimeType dateTime;
	ULong		crDate;
	Char		strDate[20];
	Char		strTime[20];
	Char		strDatetime[60];

	FieldPtr	fldP;
	Word		*line;

	l = DmFindDatabase (0, "trainrst");
	fldP = GetObjectPtr(DATRAINResultField);

	if(l!=NULL){
		d = DmOpenDatabase(0, l, dmModeReadWrite);

		PrefGetPreferences (&sysPrefs);
		DmDatabaseInfo(0, l, NULL, NULL, NULL, &crDate, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		TimSecondsToDateTime(crDate,&dateTime);

		DateToAscii(dateTime.month,dateTime.day,   dateTime.year,sysPrefs.dateFormat,strDate);
		TimeToAscii(dateTime.hour ,dateTime.minute,              sysPrefs.timeFormat,strTime);
		
		StrCat(strDatetime,strDate);
		StrCat(strDatetime,"  ");
		StrCat(strDatetime,strTime);
		StrCat(strDatetime," ̌ʂłB");
		
		SetResultValue( DATRAINDateField, strDatetime);
		
		recH=DmQueryRecord(d,0);
		recP = MemHandleLock(recH);
		SetResultValue( DATRAINResultField, recP);
		MemHandleUnlock(recH);

		recH=DmQueryRecord(d,1);
		if(recH!=NULL){
			recP = MemHandleLock(recH);
			line=(Word *)recP;
			FldSetScrollPosition(fldP,*line);
			MemHandleUnlock(recH);
		}	
		
		DmCloseDatabase(d);
	}else{
		SetResultValue( DATRAINResultField, "TRAIŇʂ܂łB" );
	}

}
void DATRAINFormTerm()
{
	FieldPtr	fldP;
	Word		line;

	LocalID		l;
	DmOpenRef	d;
	CharPtr		recP;
	VoidHand	recH;
	UInt		recNum = 1;

	fldP=GetObjectPtr(DATRAINResultField);
	line=FldGetScrollPosition(fldP);
	
	l = DmFindDatabase (0, "trainrst");
	d = DmOpenDatabase(0, l, dmModeReadWrite);
				
	recH=DmQueryRecord(d,1);
	if(recH==NULL){
		recH=DmNewRecord(d, &recNum, sizeof (Word));
	}
	recP=MemHandleLock(recH);
	DmWrite(recP, 0, &line, sizeof (Word));
	MemHandleUnlock(recH);

	DmCloseDatabase(d);
}

